<?php

class Cron_Controller extends MVC_Controller
{
	public function index()
	{
		$this->header->allow();

		$type = $this->sanitize->string($this->url->segment(3));
		$token = $this->sanitize->string($this->url->segment(4));

		if($token != system_token)
			response(500, false);

		$this->cache->container("system.settings");

        if($this->cache->empty()):
            $this->cache->setArray($this->system->getSettings());
        endif;

        set_system($this->cache->getAll());

		switch($type):
			case "echo":
				try {
					$this->echo->_cache = $this->cache;
					$this->echo->_guzzle = $this->guzzle;

					$echoToken = $this->echo->token(false, true);
				} catch(Exception $e){
					response(500);
				}

				break;
			case "quota":
				$quotas = $this->cron->getQuota();

				if(!empty($quotas)):
					foreach($quotas as $quota):
						$this->cache->container("user.{$quota["hash"]}");
						$this->cache->clear();
					endforeach;
				endif;

				$this->cron->resetQuota();

				break;
			case "whatsapp":
				$accountsArray = [];
				$accounts = $this->cron->getWaAccounts();

				if(!empty($accounts)):
					foreach($accounts as $account):
						$accountsArray[] = [
							"uid" => $account["uid"],
							"hash" => $account["hash"],
							"unique" => $account["unique"]
						];
					endforeach;

					try {
						$this->echo->_cache = $this->cache;
						$this->echo->_guzzle = $this->guzzle;

						$echoToken = $this->echo->token();
					} catch(Exception $e){
						response(500);
					}

					if($echoToken):
						$this->wa->_guzzle = $this->guzzle;
						$this->wa->process($echoToken, $accountsArray);
					endif;
				endif;

				break;
			case "sms.scheduled":
				$schedules = $this->cron->getScheduled();

				if(!empty($schedules)):
					foreach($schedules as $scheduled):
				    	date_default_timezone_set(
				    		$scheduled["timezone"] ?: "UTC"
				    	);

				    	$rejected = false;

				    	if($scheduled["mode"] < 2):
				    		$subscription = set_subscription(
			                    $this->system->checkSubscription($scheduled["uid"]), 
			                    $this->system->getSubscription(false, $scheduled["uid"]), 
			                    $this->system->getSubscription(false, false, true)
			                );

							if(empty($subscription))
								$rejected = true;

							if(!$this->sanitize->isInt($scheduled["sim"]))
								$rejected = true;

			    			if(empty($this->system->getDevices($scheduled["uid"])))
			    				$rejected = true;

			    			if($this->system->checkDevice($scheduled["uid"], $scheduled["did"], "did") < 1)
		    					$rejected = true;

			    			$device = $this->system->getDevice($scheduled["uid"], $scheduled["did"], "did");
				    	else:
				    		if($scheduled["gateway"] > 0):
				    			$gateways = $this->system->getGateways();

								if(!array_key_exists($scheduled["gateway"], $gateways)):
									$rejected = true;
								endif;

								if(!$this->file->exists("system/gateways/" . md5($scheduled["gateway"]) . ".php"))
									$rejected = true;

								require "system/gateways/" . md5($scheduled["gateway"]) . ".php";
				    		else:
				    			$device = $this->system->getDevice(false, $scheduled["did"], "did");

				    			if($device):
					    			if($device["global_device"] > 1):
					    				$rejected = true;
					    			endif;
					    		else:
					    			$rejected = true;
					    		endif;
				    		endif;
				    	endif;
						
						if(!$rejected):
							$approve = true;

					        if($scheduled["repeat"] < 2):
				        		if(!empty($scheduled["last_send"])):
				        			if(date("Y") == date("Y", $scheduled["last_send"])):
				        				$approve = false;
				        			else:
				        				$send_date = date("d-m-* H:i:s", $scheduled["send_date"]);

				        				if(time() < strtotime(str_replace("*", date("Y"), $send_date))):
											$approve = false;
										endif;
				        			endif;
				        		else:
				        			if(time() < $scheduled["send_date"]):
										$approve = false;
									endif;
				        		endif;
							else:
								if(time() < $scheduled["send_date"]):
									$approve = false;
								endif;
							endif;

							if($approve):
								$contactBook = [];

				    			$groups = explode(",", $scheduled["groups"]);

				    			if(!in_array(0, $groups)):
									foreach($groups as $group):
										if($this->system->checkGroup($scheduled["uid"], $group) > 0):
											$contacts = $this->system->getContactsByGroup($scheduled["uid"], $group);

											if(!empty($contacts)):
												foreach($contacts as $contact):
										        	$contactBook[] = [
														"name" => $contact["name"],
														"phone" => $contact["phone"],
														"group" => $contact["group"]
													];
												endforeach;
											endif;
										endif;
									endforeach;
								endif;

								$numbers = explode("\n", trim($scheduled["numbers"]));

								if(!empty($numbers) && !empty($numbers[0])):
									foreach($numbers as $number):
										$valid = true;

										try {
										    $phone = $this->phone->parse($number, $scheduled["country"]);

							    			$phone->format(Brick\PhoneNumber\PhoneNumberFormat::INTERNATIONAL);

										    if(!$phone->isValidNumber())
												$valid = false;

											if(!$phone->getNumberType(Brick\PhoneNumber\PhoneNumberType::MOBILE))
												$valid = false;

											$phoneNumber = $phone->format(Brick\PhoneNumber\PhoneNumberFormat::E164);
										} catch(Brick\PhoneNumber\PhoneNumberParseException $e) {
											$valid = false;
										}

										if($valid):
											$contactBook[] = [
												"name" => $phoneNumber,
												"phone" => $phoneNumber,
												"group" => "Unknown"
											];
										endif;
									endforeach;
								endif;

								foreach($contactBook as $contact):
									try {
									    $phone = $this->phone->parse($contact["phone"]);
										$country = $phone->getRegionCode();
									} catch(Brick\PhoneNumber\PhoneNumberParseException $e) {
										// ignore
									}

									if($scheduled["mode"] < 2):
										if(!limitation($subscription["send_limit"], $this->system->countQuota($scheduled["uid"], "sent"))):
							        		$this->system->create("sent", [
									        	"uid" => $scheduled["uid"],
												"did" => $scheduled["did"],
												"gateway" => 0,
												"sim" => $scheduled["sim"],
												"mode" => 1,
												"phone" => $contact["phone"],
												"message" => bjoernffm\Spintax\Parser::parse($this->lex->parse(footermark($subscription["footermark"], $scheduled["message"], system_message_mark), [
							        				"contact" => [
							        					"name" => $contact["name"],
							        					"number" => $contact["phone"]
							        				],
							        				"group" => [
							        					"name" => $contact["group"]
							        				],
							        				"date" => [
							        					"now" => date("F j, Y"),
							        					"time" => date("h:i A") 
							        				]
							        			]))->generate(),
												"status" => 1,
												"status_code" => false,
												"priority" => 1,
												"api" => 2,
												"create_date" => date("Y-m-d H:i:s", time())
									        ]);
									    endif;
									else:
										$credits = $this->system->getCredits($scheduled["uid"]);

										if($this->sanitize->isInt($scheduled["gateway"])):
											$pricing = json_decode($gateways[$scheduled["gateway"]]["pricing"], true);

											if(array_key_exists(strtolower($country), $pricing["countries"])):
												$price = $pricing["countries"][strtolower($country)];
											else:
												$price = $pricing["default"];
											endif;

											if($credits >= $price):
												$gateway = $gateways[$scheduled["gateway"]];

												$message = bjoernffm\Spintax\Parser::parse($scheduled["message"])->generate();

												$send = gatewaySend($contact["phone"], $message, $this);

												if($send):
													$create = $this->system->create("sent", [
														"uid" => $scheduled["uid"],
														"did" => false,
														"gateway" => $scheduled["gateway"],
														"api" => 0,
														"sim" => 0,
														"mode" => 2,
														"priority" => 0,
														"phone" => $contact["phone"],
														"message" => $message,
														"status" => $gateway["callback"] < 2 ? 2 : 3,
														"status_code" => false
													]);

													if($gateway["callback"] < 2):
														$this->cache->container("system.gateways");

														$this->cache->set("{$gateway["callback_id"]}.{$send}", $create);
													endif;
												endif;
											endif;
										else:
											$currency = country($device["country"])->getCurrency()["iso_4217_code"];

											$this->cache->container("system.payments", true);

											if(!$this->cache->has("exchange")):
												try {
										            $exchange = json_decode($this->guzzle->get(titansys_api . "/currency?code=" . system_purchase_code, [
										                "allow_redirects" => true,
										                "http_errors" => false
										            ])->getBody()->getContents(), true);


										            if($exchange["status"] == 200):
										            	$this->cache->set("exchange", $exchange, 43200);
										            endif;
										        } catch(Exception $e){
										            // ignore
										        }
										    endif;

										    if($this->cache->has("exchange")):
											    $rates = $this->cache->get("exchange");

											    $base_rate = $rates["data"]["USD"] / $rates["data"][strtoupper($currency)];
										        $usd_price = ($base_rate * $device["rate"]) * $rates["data"]["USD"];
										        $final_price = (float) abs($usd_price * $rates["data"][strtoupper(system_currency)]);

										        if($credits >= ($final_price * count($contactBook))):
													$slots = explode(",", $device["global_slots"]);
													$sim = count($slots) > 1 ? rand(1, 2) : ($slots[0] < 2 ? 1 : 2);

									        		$this->system->create("sent", [
											        	"uid" => $scheduled["uid"],
														"did" => $scheduled["did"],
														"gateway" => 0,
														"sim" => $sim,
														"mode" => 2,
														"phone" => $contact["phone"],
														"message" => bjoernffm\Spintax\Parser::parse($this->lex->parse($scheduled["message"], [
									        				"contact" => [
									        					"name" => $contact["name"],
									        					"number" => $contact["phone"]
									        				],
									        				"group" => [
									        					"name" => $contact["group"]
									        				],
									        				"date" => [
									        					"now" => date("F j, Y"),
									        					"time" => date("h:i A") 
									        				]
									        			]))->generate(),
														"status" => 1,
														"status_code" => false,
														"priority" => 1,
														"api" => 2,
														"create_date" => date("Y-m-d H:i:s", time())
											        ]);
									        	endif;
									        endif;
										endif;
									endif;
								endforeach;

								if($scheduled["mode"] < 2):
									if(round((int) $device["version"]) > 7):
										$this->fcm->send(md5($scheduled["uid"] . $scheduled["did"]), [
									    	"type" => "sms",
									    	"global" => 0,
									    	"currency" => "None",
									    	"rate" => (float) 0
									    ]);
									else:
										try {
						        			$this->echo->_cache = $this->cache;
											$this->echo->_guzzle = $this->guzzle;

											$echoToken = $this->echo->token();

											if($echoToken):
												$this->echo->notify("legacy_" . md5($scheduled["uid"] . $scheduled["did"]), [
													"type" => "sms",
											    	"global" => 0,
											    	"currency" => "None",
											    	"rate" => (float) 0
												]);
											endif;
						        		} catch(Exception $e){
						        			// Ignore
						        		}
									endif;
								else:
									if($scheduled["gateway"] < 1):
										if(round((int) $device["version"]) > 7):
											$this->fcm->send(md5($scheduled["uid"] . $scheduled["did"]), [
										    	"type" => "sms",
										    	"global" => 1,
										    	"currency" => $currency,
										    	"rate" => (float) $device["rate"]
										    ]);
										else:
											try {
							        			$this->echo->_cache = $this->cache;
												$this->echo->_guzzle = $this->guzzle;

												$echoToken = $this->echo->token();

												if($echoToken):
													$this->echo->notify("legacy_" . md5($scheduled["uid"] . $scheduled["did"]), [
														"type" => "sms",
												    	"global" => 1,
												    	"currency" => $currency,
												    	"rate" => (float) $device["rate"]
													]);
												endif;
							        		} catch(Exception $e){
							        			// Ignore
							        		}
										endif;
									endif;
								endif;

								if($scheduled["repeat"] < 2):
									$this->cron->updateLastSend($scheduled["id"], time());
								else:
									$this->system->delete($scheduled["uid"], $scheduled["id"], "scheduled");
								endif;
							endif;
						endif;
					endforeach;
				endif;

				break;
			case "wa.scheduled":
				$schedules = $this->cron->getScheduled(true);

				if(!empty($schedules)):
					foreach($schedules as $scheduled):
				    	date_default_timezone_set(
				    		$scheduled["timezone"] ?: "UTC"
				    	);

				    	$rejected = false;

				    	$subscription = set_subscription(
		                    $this->system->checkSubscription($scheduled["uid"]), 
		                    $this->system->getSubscription(false, $scheduled["uid"]), 
		                    $this->system->getSubscription(false, false, true)
		                );

						if(empty($subscription))
							$rejected = true;

						if($this->cron->checkWaAccount($scheduled["uid"], $scheduled["wid"]) < 1)
							$rejected = true;
						
						if(!$rejected):
							$approve = true;

							if($scheduled["repeat"] < 2):
				        		if(!empty($scheduled["last_send"])):
				        			if(date("Y") == date("Y", $scheduled["last_send"])):
				        				$approve = false;
				        			else:
				        				$send_date = date("d-m-* H:i:s", $scheduled["send_date"]);

				        				if(time() < strtotime(str_replace("*", date("Y"), $send_date))):
											$approve = false;
										endif;
				        			endif;
				        		else:
				        			if(time() < $scheduled["send_date"]):
										$approve = false;
									endif;
				        		endif;
							else:
								if(time() < $scheduled["send_date"]):
									$approve = false;
								endif;
							endif;

							if($approve):
								$contactBook = [];

				    			$groups = explode(",", $scheduled["groups"]);

				    			if(!in_array(0, $groups)):
									foreach($groups as $group):
										if($this->system->checkGroup($scheduled["uid"], $group) > 0):
											$contacts = $this->system->getContactsByGroup($scheduled["uid"], $group);

											if(!empty($contacts)):
												foreach($contacts as $contact):
													$rejected = false;

													try {
													    $phone = $this->phone->parse($contact["phone"], $scheduled["country"]);

													    $country = strtolower($phone->getRegionCode());
														$phoneNumber = $phone->format(Brick\PhoneNumber\PhoneNumberFormat::E164);

														if($country == "br"):
															$partOne = (string) Stringy\create($phoneNumber)->first(5);
															$partTwo = (string) Stringy\create($phoneNumber)->last(8);
															$phoneNumber = "{$partOne}{$partTwo}";
														endif;
													} catch(Brick\PhoneNumber\PhoneNumberParseException $e) {
														$rejected = true;
													}

													if($this->system->checkUnsubscribed($scheduled["uid"], $phone) > 0)
														$rejected = true;

													if(!$rejected):
														$contactBook[] = [
															"name" => $contact["name"],
															"phone" => $phoneNumber,
															"group" => $contact["group"]
														];
													endif;
												endforeach;
											endif;
										endif;
									endforeach;
								endif;

								$numbers = explode("\n", trim($scheduled["numbers"]));

								if(!empty($numbers) && !empty($numbers[0])):
									foreach($numbers as $number):
										$valid = true;

										try {
										    $phone = $this->phone->parse($number, $scheduled["country"]);

							    			$phone->format(Brick\PhoneNumber\PhoneNumberFormat::INTERNATIONAL);

										    if(!$phone->isValidNumber())
												$valid = false;

											if(!$phone->getNumberType(Brick\PhoneNumber\PhoneNumberType::MOBILE))
												$valid = false;

											$country = strtolower($phone->getRegionCode());
											$phoneNumber = $phone->format(Brick\PhoneNumber\PhoneNumberFormat::E164);

											if($country == "br"):
												$partOne = (string) Stringy\create($phoneNumber)->first(5);
												$partTwo = (string) Stringy\create($phoneNumber)->last(8);
												$phoneNumber = "{$partOne}{$partTwo}";
											endif;
										} catch(Brick\PhoneNumber\PhoneNumberParseException $e) {
											$valid = false;
										}

										if($valid):
											$contactBook[] = [
												"name" => $phoneNumber,
												"phone" => $phoneNumber,
												"group" => "Unknown"
											];
										endif;
									endforeach;
								endif;

								foreach($contactBook as $contact):
									if(!limitation($subscription["wa_send_limit"], $this->system->countQuota($scheduled["uid"], "wa_sent"))):
						        		$this->system->create("wa_sent", [
								        	"uid" => $scheduled["uid"],
								        	"wid" => $scheduled["wid"],
											"phone" => $contact["phone"],
											"message" => bjoernffm\Spintax\Parser::parse($this->lex->parse(footermark($subscription["footermark"], $scheduled["message"], system_message_mark), [
						        				"contact" => [
						        					"name" => $contact["name"],
						        					"number" => $contact["phone"]
						        				],
						        				"group" => [
						        					"name" => $contact["group"]
						        				],
						        				"date" => [
						        					"now" => date("F j, Y"),
						        					"time" => date("h:i A") 
						        				]
						        			]))->generate(),
											"status" => 1,
											"api" => 2,
											"create_date" => date("Y-m-d H:i:s", time())
								        ]);
								    endif;
								endforeach;

								$account = $this->cron->getWaAccount($scheduled["uid"], $scheduled["wid"]);

								try {
									$this->echo->_cache = $this->cache;
									$this->echo->_guzzle = $this->guzzle;

									$echoToken = $this->echo->token();
								} catch(Exception $e){
									response(500);
								}

								if($echoToken):
									$this->echo->notify($scheduled["hash"], [
		                                "type" => "table"
		                            ]);

		                            $this->wa->_guzzle = $this->guzzle;

		                            $this->wa->process($echoToken, [
										[
											"uid" => $scheduled["uid"],
											"hash" => $scheduled["hash"],
											"unique" => $account["unique"]
										]
									]);

									if($this->wa->send($echoToken, $scheduled["hash"], $account["unique"])):
										if($scheduled["repeat"] < 2):
											$this->cron->updateLastSend($scheduled["id"], time(), true);
										else:
											$this->system->delete($scheduled["uid"], $scheduled["id"], "wa_scheduled");
										endif;
									endif;
								endif;
							endif;
						endif;
					endforeach;
				endif;

				break;
			case "subscription":
				$subscriptions = $this->cron->getSubscriptions();

				if(!empty($subscriptions)):
					foreach($subscriptions as $subscription):
						set_language($subscription["language"]);

						if(time() >= $subscription["expire"]):
							$this->system->delete(false, $subscription["id"], "subscriptions");

							$this->mail->send([
								"title" => system_site_name,
								"data" => [
									"subject" => mail_title(__("lang_cron_package_expired"))
								]
							], $subscription["email"], "_mail/expired.tpl", $this->smarty);

							usleep(500000);
						endif;

						if(round(abs((time() - $subscription["expire"]) / (60 * 60 * 24))) <= 5):
							$this->mail->send([
								"title" => system_site_name,
								"data" => [
									"subject" => mail_title(__("lang_cron_package_expiring"))
								]
							], $subscription["email"], "_mail/expiring.tpl", $this->smarty);

							usleep(500000);
						endif;
					endforeach;
				endif;

				break;
			default:
				response(500);
		endswitch;

		response(200);
	}
}