paypal.Buttons({
    createOrder: (data, actions) => {
        return actions.order.create({
            "purchase_units": [{
                "custom_id": paypalItem.id,
                "description": paypalItem.name,
                "amount": {
                    "currency_code": paypalItem.currency,
                    "value": paypalItem.amount,
                    "breakdown": {
                        "item_total": {
                            "currency_code": paypalItem.currency,
                            "value": paypalItem.amount
                        }
                    }
                },
                "items": [
                    {
                        "name": paypalItem.name,
                        "description": paypalItem.description,
                        "unit_amount": {
                            "currency_code": paypalItem.currency,
                            "value": paypalItem.amount
                        },
                        "quantity": "1",
                        "category": "DIGITAL_GOODS"
                    },
                ]
            }]
        });
    },
    onApprove: (data, actions) => {
        return actions.order.capture().then(function (orderData) {
            let postData = {
                paypal_order_check: 1,
                order_id: orderData.id
            };

            system.loader(lang_js_processing_dataloader);

            fetch(`${site_url}/plugin?name=paypal-payment&hash=${paypalItem.hash}&action=validate&json=true`, {
                method: 'POST',
                headers: { 'Accept': 'application/json' },
                body: encodeFormData(postData)
            }).then((response) => response.json()).then((result) => {
                system.loader(false, false);

                if (result.status == 200) {
                    window.location.href = `${site_url}/plugin?name=paypal-payment&action=success`;
                } else if(result.status == 301) {
                    window.location.href = `${site_url}/dashboard/auth`;
                } else {
                    alert.danger(result.message);
                }
            }).catch(error => console.log(error));
        });
    }
}).render('#paypal-button-container');

const encodeFormData = (data) => {
    let form_data = new FormData();

    for (var key in data) {
        form_data.append(key, data[key]);
    }

    return form_data;
}