SET CHARACTER SET utf8mb4;

DELETE FROM `settings`
WHERE ((`name` = 'login_recaptcha'));

INSERT INTO `settings` (`name`, `value`)
VALUES ('auth_redirect', '1');

INSERT INTO `settings` (`name`, `value`)
VALUES ('default_country', 'PH');

INSERT INTO `settings` (`name`, `value`)
VALUES ('default_timezone', 'asia/manila');

INSERT INTO `settings` (`name`, `value`)
VALUES ('mailing_triggers', '0');

INSERT INTO `settings` (`name`, `value`)
VALUES ('recaptcha', '2');

INSERT INTO `settings` (`name`, `value`)
VALUES ('mailing_address', '');

ALTER TABLE `users`
ADD `confirmed` tinyint NOT NULL AFTER `partner`;

ALTER TABLE `devices`
CHANGE `random_min` `random_min` int NOT NULL AFTER `random_send`,
CHANGE `random_max` `random_max` int NOT NULL AFTER `random_min`;

ALTER TABLE `devices`
ADD `receive_sms` tinyint NOT NULL AFTER `packages`;

ALTER TABLE `wa_accounts`
ADD `random_send` tinyint NOT NULL AFTER `unique`,
ADD `random_min` int NOT NULL AFTER `random_send`,
ADD `random_max` int NOT NULL AFTER `random_min`;

ALTER TABLE `wa_accounts`
ADD `receive_chats` tinyint NOT NULL AFTER `unique`;

UPDATE `users` SET `confirmed` = 1;

UPDATE `devices` SET `receive_sms` = 1;

UPDATE `wa_accounts` SET `receive_chats` = 1, `random_send` = 2, `random_min` = 1, `random_max` = 5;